#!/bin/bash
export datasets="Cora CiteSeer PubMed cs physics wikics OGBN-Arxiv"
export datasets2="OGBN-Arxiv"
export missing_rates="0.6 0.7 0.8 0.9"
export missing_rates_test="0.1"
export lambda_list="1e-5 1e-4 1e-3 1e-2 1e-1 1e+0 1e+1"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=2

for dataset in $datasets
do
for missing_rate in $missing_rates
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --embedder GOODIE_best --gnn GCN --filling_method fp --n_runs 10 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type row --missing_rate ${missing_rate} --embedder GOODIE_best --gnn GCN --filling_method fp --n_runs 10 --gpu ${gpu}
done
done